function residual = static_resid(T, y, x, params, T_flag)
% function residual = static_resid(T, y, x, params, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T         [#temp variables by 1]  double   vector of temporary terms to be filled by function
%   y         [M_.endo_nbr by 1]      double   vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1]       double   vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1]     double   vector of parameter values in declaration order
%                                              to evaluate the model
%   T_flag    boolean                 boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = World_Economy_Competitive.static_resid_tt(T, y, x, params);
end
residual = zeros(33, 1);
lhs = exp(y(18));
rhs = T(7)^(params(2)/(params(2)-1));
residual(1) = lhs - rhs;
lhs = exp(y(1));
rhs = params(11)*T(8)*T(10);
residual(2) = lhs - rhs;
lhs = exp(y(23));
rhs = T(3)*T(8)*T(2)*(1-params(11))*(1-params(3))*T(11)*T(12);
residual(3) = lhs - rhs;
lhs = exp(y(22));
rhs = T(4)*T(11)*T(8)*T(2)*(1-params(11))*params(3)*T(13);
residual(4) = lhs - rhs;
lhs = exp(y(12));
rhs = T(2)*exp(y(19)*params(3))*exp(y(20)*(1-params(3)));
residual(5) = lhs - rhs;
lhs = exp(y(19))+exp(y(21))+exp(y(3))+exp(y(2))+params(6)*exp(params(5)*y(11))*exp(y(7))+params(6)*exp(params(5)*(y(10)-y(26)))*exp(y(6));
rhs = exp(y(18))+exp(y(19))*(1-params(10));
residual(6) = lhs - rhs;
lhs = exp(y(20));
rhs = T(14)*exp(y(23))^(1/params(8));
residual(7) = lhs - rhs;
lhs = 1;
rhs = T(15)*(1+exp(y(22))-params(10));
residual(8) = lhs - rhs;
lhs = T(15);
rhs = params(1);
residual(9) = lhs - rhs;
lhs = y(13);
rhs = T(15)*(exp(y(1))*exp(y(11))+y(13)*(1-exp(y(11)))-params(6)*exp(params(5)*y(11)));
residual(10) = lhs - rhs;
lhs = y(14);
rhs = y(13)*params(7)+y(14)*T(15)*(1-params(7));
residual(11) = lhs - rhs;
lhs = y(14)*params(4)*exp(y(3)*(params(4)-1))*T(16);
rhs = 1;
residual(12) = lhs - rhs;
lhs = T(15)*params(6)*params(5)*exp(y(11)*(params(5)-1));
rhs = T(15)*(exp(y(1))-y(13));
residual(13) = lhs - rhs;
lhs = y(16);
rhs = T(17);
residual(14) = lhs - rhs;
lhs = y(17);
rhs = params(7)*y(16)+T(15)*(1-params(7))*y(17);
residual(15) = lhs - rhs;
lhs = y(17)*params(4)*exp(y(2)*(params(4)-1))*T(18);
rhs = 1;
residual(16) = lhs - rhs;
lhs = T(15)*params(6)*params(5)*exp(y(10)*(params(5)-1))*exp(y(26)*(-params(5)));
rhs = T(15)*exp((-y(26)))*(exp(y(1))-y(16));
residual(17) = lhs - rhs;
lhs = exp(y(7));
rhs = exp(y(7))*(1-exp(y(11)))+params(7)*exp(y(9));
residual(18) = lhs - rhs;
lhs = exp(y(6));
rhs = exp(y(6))*(1-exp((-y(26)))*exp(y(10)))+params(7)*exp(y(8));
residual(19) = lhs - rhs;
lhs = exp(y(9));
rhs = (1-params(7))*exp(y(9))+T(16)*exp(y(3)*params(4));
residual(20) = lhs - rhs;
lhs = exp(y(8));
rhs = (1-params(7))*exp(y(8))+T(18)*exp(y(2)*params(4));
residual(21) = lhs - rhs;
lhs = exp(y(5));
rhs = exp(y(7))*exp(y(11));
residual(22) = lhs - rhs;
lhs = exp(y(4));
rhs = exp(y(6))*exp((-y(26)))*exp(y(10));
residual(23) = lhs - rhs;
lhs = exp(y(15));
rhs = exp(y(5))+exp(y(4));
residual(24) = lhs - rhs;
lhs = y(26);
rhs = x(1);
residual(25) = lhs - rhs;
lhs = y(25);
rhs = x(2)+y(25)*params(15)+y(25)*params(16);
residual(26) = lhs - rhs;
residual(27) = y(27);
residual(28) = y(28);
residual(29) = y(29);
residual(30) = y(30);
residual(31) = y(31);
residual(32) = y(32);
lhs = y(33);
rhs = y(25);
residual(33) = lhs - rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
end
